// controllers/form_siswaController.js
const MasterGerejaModels = require('../models/MasterGerejaModels');

const GetGerejaByID = async (req, res) => {
  const { GerejaID } = req.query; // Use req.query to get the query parameter

  try {
    const gerejabyid = await MasterGerejaModels.getGerejabyID(GerejaID);
    if (!gerejabyid) {
      return res.status(404).json({ message: 'Form not found' });
    }
    res.json(gerejabyid);
  } catch (error) {
    res.status(500).json({ message: error.message });
  }
};
const GetGereja = async (req, res) => {
    try {
      const gerejaList = await MasterGerejaModels.getGereja();
      if (!gerejaList.length) {
        return res.status(404).json({ message: 'No records found' });
      }
      res.json(gerejaList);
    } catch (error) {
      res.status(500).json({ message: error.message });
    }
  };
  
module.exports = { GetGerejaByID,GetGereja };
