const pool = require('../config/dbConfig');

const getProfilebyID = async (ProfileID) => {
  try {
    const [rows] = await pool.query('SELECT * FROM user_profile WHERE ProfileID = ?', [ProfileID]);
    // console.log('Query Result:', rows); // Log the result
    return rows[0]; // Return the first result
  } catch (error) {
    console.error('Database query error:', error);
    throw new Error('Database query failed');
  }
};

const GetProfile = async () => {
  try {
    const [rows] = await pool.query('SELECT * FROM user_profile');
    // console.log('Query Result:', rows); // Log the result
    return rows; // Return the full list of results
  } catch (error) {
    console.error('Database query error:', error);
    throw new Error('Database query failed');
  }
};
const insertProfile = async (profileData) => {
    try {
      const query = `INSERT INTO user_profile 
  (UserID,  TahunAjaran, Gelombang, KategoriCalonSiswa, NomorFormOnline, NoSPJ, NISN, NamaCalonSiswa, NIKNo, TempatLahirCalonSiswa, TanggalLahirCalonSiswa, JenisKelaminCalonSiswa, Agama, Gereja, GKI, AnakKe, JumlahSaudara, NomorKartuKeluarga, NamaAsalSekolah, NoKTPAyah, NamaAyah, NoKTPIbu, NamaIbu, PekerjaanAyah, PekerjaanIbu, NomorTelepon, NomorPonselAyah, NomorPonselIbu, EmailAyah, EmailIbu, KategoriTarif, Jenjang, Program1, SekolahTujuan1, KelasTujuan1, CaraPembayaranUangSekolah1, Program2, SekolahTujuan2, KelasTujuan2, AlamatSiswa, KodePosSiswa, AlamatOrangTua, KodePosOrangTua)
  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?)`;
  
  const values = [
    profileData.UserID, 
     
    profileData.TahunAjaran, 
    profileData.Gelombang, 
    profileData.KategoriCalonSiswa,
    profileData.NomorFormOnline, 
    profileData.NoSPJ, 
    profileData.NISN, 
    profileData.NamaCalonSiswa, 
    profileData.NIKNo, 
    profileData.TempatLahirCalonSiswa,
    profileData.TanggalLahirCalonSiswa,
    profileData.JenisKelaminCalonSiswa,
    profileData.Agama, 
    profileData.Gereja,
    profileData.GKI, 
    profileData.AnakKe,
    profileData.JumlahSaudara, 
    profileData.NomorKartuKeluarga, 
    profileData.NamaAsalSekolah, 
    profileData.NoKTPAyah, 
    profileData.NamaAyah,
    profileData.NoKTPIbu, 
    profileData.NamaIbu, 
    profileData.PekerjaanAyah, 
    profileData.PekerjaanIbu, 
    profileData.NomorTelepon, 
    profileData.NomorPonselAyah,
    profileData.NomorPonselIbu, 
    profileData.EmailAyah, 
    profileData.EmailIbu, 
    profileData.KategoriTarif, 
    profileData.Jenjang, 
    profileData.Program1,
    profileData.SekolahTujuan1, 
    profileData.KelasTujuan1, 
    profileData.CaraPembayaranUangSekolah1, 
    profileData.Program2, 
    profileData.SekolahTujuan2,
    profileData.KelasTujuan2, 
    profileData.AlamatSiswa, 
    profileData.KodePosSiswa, 
    profileData.AlamatOrangTua, 
    profileData.KodePosOrangTua
  ];
  
  
      const [result] = await pool.query(query, values);
      return result.insertId; // Return the ID of the inserted record
    } catch (error) {
      console.error('Database insert error:', error);
      throw new Error('Database insert failed');
    }
  };

module.exports = {
  getProfilebyID,
  GetProfile,
  insertProfile
};
