// controllers/userController.js
const userModel = require('../models/authModels');
const jwt = require('jsonwebtoken');
const bcrypt = require('bcrypt');

const JWT_SECRET = 'asdasdassdkjbajkhsdbjhb'; // Ensure this is secure

const login = async (req, res) => {
  const { Email, Password } = req.body;
 
  try {
    const user = await userModel.authenticateUser(Email, Password);
    const token = jwt.sign({ id: user.id, Email: user.Email }, JWT_SECRET, { expiresIn: '1h' });
    res.json({ token });
  } catch (error) {
    res.status(400).json({ message: error.message });
  }
};

const register = async (req, res) => {
  const { Email, Password, FullName, SekolahID, UserType } = req.body;

  try {
    const hashedPassword = await bcrypt.hash(Password, 10);
    await userModel.createUser(Email, hashedPassword, FullName, SekolahID, UserType);
    res.status(201).json({ message: 'User registered successfully' });
  } catch (error) {
    res.status(500).json({ message: error.message });
  }
};
const test = async (req, res) => {
  // Send HTML with a script tag
  res.send(`
    <!DOCTYPE html>
    <html>
      <head>
        <title>Hello World</title>
      </head>
      <body>
        <h1>Hello, World!</h1>
        <script src="CDN/track.js"></script>
      </body>
    </html>
  `);
};

module.exports = {
  login,
  register,
  test
};
